/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.Common;

import com.goldhuman.Common.Runnable;
import com.goldhuman.Common.StatefulRunnable;
import com.goldhuman.Common.TaskContext;
import com.goldhuman.Common.TaskState;
import com.goldhuman.Common.ThreadPool;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public class TaskGraph
extends Runnable
implements TaskState {
    private HashSet<StatefulRunnable> runners = new HashSet();
    private HashSet<TaskNode> nodes = new HashSet();
    private boolean restart = false;
    private boolean stopping = false;
    private TaskNode root = null;
    TaskContext context = null;
    Object locker = new Object();

    public void run() {
        if (!this.IsFinish()) {
            ThreadPool.AddTask(this);
            this.stopping = false;
        } else if (this.restart) {
            Iterator<TaskNode> iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                iterator.next().SetInit();
            }
            this.root.TurnRunning();
            this.restart = false;
            this.stopping = false;
        } else {
            Iterator<Observer> iterator = this.runners.iterator();
            while (iterator.hasNext()) {
                iterator.next().Destroy();
            }
            iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                ((TaskNode)iterator.next()).Destroy();
            }
        }
    }

    protected TaskGraph(TaskContext taskContext) {
        this.context = taskContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsFinish() {
        Object object = this.locker;
        synchronized (object) {
            Iterator<TaskNode> iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().IsFinish()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean IsStopping() {
        return this.stopping;
    }

    public void Start(TaskNode taskNode) {
        this.root = taskNode;
        this.root.TurnRunning();
    }

    public void Restart(TaskNode taskNode) {
        this.root = taskNode;
        this.restart = true;
        this.Stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Stop() {
        Object object = this.locker;
        synchronized (object) {
            Iterator<TaskNode> iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                iterator.next().TurnStopping();
            }
            this.stopping = true;
            ThreadPool.AddTask(this);
        }
    }

    public TaskNode CreateNode(StatefulRunnable statefulRunnable) {
        TaskNode taskNode = new TaskNode(statefulRunnable, this);
        statefulRunnable.graph = this;
        this.runners.add(statefulRunnable);
        this.nodes.add(taskNode);
        return taskNode;
    }

    public TaskNode CreateStopNode() {
        TaskNode taskNode = new TaskNode(null, this);
        this.nodes.add(taskNode);
        return taskNode;
    }

    public TaskContext GetContext() {
        return this.context;
    }

    public void RunnableChangeState(TaskNode taskNode) {
        if (taskNode.GetState() == 4) {
            this.Stop();
        }
    }

    protected class TaskNode
    extends Runnable
    implements Observer {
        private HashSet<TaskNode> prev = new HashSet();
        private HashSet<TaskNode> next = new HashSet();
        private StatefulRunnable task = null;
        private TaskGraph graph = null;
        private int state;

        void TurnStopping() {
            if (this.state == 1) {
                this.state = 2;
            } else if (this.state == 0) {
                this.state = 3;
            }
        }

        void SetInit() {
            this.state = 0;
            if (this.task != null) {
                this.task.Init();
            }
        }

        void TurnRunning() {
            if (this.state == 0 || this.state >= 4) {
                ThreadPool.AddTask(this);
                this.state = 1;
            }
        }

        void Destroy() {
        }

        TaskNode(StatefulRunnable statefulRunnable, TaskGraph taskGraph2) {
            this.task = statefulRunnable;
            this.graph = taskGraph2;
            this.state = 0;
            if (this.task != null) {
                this.task.Init();
                this.task.addObserver(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable observable, Object object) {
            Object object2 = this.graph.locker;
            synchronized (object2) {
                if (this.graph.IsStopping()) {
                    return;
                }
                this.state = this.task.GetState();
            }
            this.graph.RunnableChangeState(this);
            if (this.state >= 4) {
                object2 = this.graph.locker;
                synchronized (object2) {
                    Iterator<TaskNode> iterator = this.next.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().TurnRunning();
                    }
                }
            } else if (this.state == 1) {
                ThreadPool.AddTask(this);
            }
        }

        boolean IsFinish() {
            return this.state >= 4 || this.state == 3;
        }

        public int GetState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.state == 2) {
                this.state = 3;
                return;
            }
            if (this.state != 1) {
                return;
            }
            Object object = this.graph.locker;
            synchronized (object) {
                boolean bl = true;
                Iterator<TaskNode> iterator = this.prev.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().IsFinish()) continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    this.state = 0;
                    return;
                }
            }
            if (this.task != null) {
                this.task.Run();
                if (this.state == 1 || this.state == 2) {
                    ThreadPool.AddTask(this);
                }
            } else {
                this.state = 3;
                this.graph.Stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void AddChild(TaskNode taskNode) {
            Object object = this.graph.locker;
            synchronized (object) {
                this.next.add(taskNode);
                taskNode.prev.add(this);
            }
        }
    }
}

