/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.Common;

import com.goldhuman.Common.Conf;
import com.goldhuman.Common.Runnable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThreadPool
implements java.lang.Runnable {
    private static SortedMap tasks = new TreeMap();
    private static SortedMap count = new TreeMap();
    private static int task_count = 0;
    private static LinkedList remove = new LinkedList();
    public Integer priority;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPool(Integer n) {
        this.priority = n;
        SortedMap sortedMap = count;
        synchronized (sortedMap) {
            Integer n2 = (Integer)count.get(n);
            count.put(n, new Integer(n2 == null ? 1 : n2 + 1));
        }
    }

    private Runnable GetTask(SortedMap sortedMap) {
        Iterator iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            LinkedList linkedList = (LinkedList)iterator.next().getValue();
            if (linkedList.isEmpty()) continue;
            return (Runnable)linkedList.removeLast();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    Runnable runnable = null;
                    Object object = tasks;
                    synchronized (object) {
                        while (task_count == 0) {
                            tasks.wait();
                        }
                        runnable = this.GetTask(tasks.tailMap(this.priority));
                        if (runnable == null) {
                            runnable = this.GetTask(tasks);
                        }
                        --task_count;
                    }
                    runnable.run();
                    object = remove;
                    synchronized (object) {
                        if (!remove.isEmpty() && this.priority.equals(remove.getLast())) {
                            remove.removeLast();
                            return;
                        }
                    }
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddTask(Runnable runnable) {
        SortedMap sortedMap = tasks;
        synchronized (sortedMap) {
            Integer n = new Integer(runnable.GetPriority());
            LinkedList<Runnable> linkedList = (LinkedList<Runnable>)tasks.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<Runnable>();
                tasks.put(n, linkedList);
            }
            linkedList.addFirst(runnable);
            ++task_count;
            tasks.notify();
        }
    }

    public static int TaskCount() {
        return task_count;
    }

    public static void AddThread(int n) {
        new Thread(new ThreadPool(new Integer(n))).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ThreadCount() {
        int n = 0;
        SortedMap sortedMap = count;
        synchronized (sortedMap) {
            Iterator iterator = count.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Integer)iterator.next().getValue()).intValue();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ThreadCount(int n) {
        int n2 = 0;
        SortedMap sortedMap = count;
        synchronized (sortedMap) {
            Integer n3 = (Integer)count.get(new Integer(n));
            if (n3 != null) {
                n2 = n3;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RemoveThread(int n) {
        Integer n2 = new Integer(n);
        SortedMap sortedMap = count;
        synchronized (sortedMap) {
            Integer n3 = (Integer)count.get(n2);
            if (n3 != null) {
                int n4 = n3 - 1;
                if (n4 > 0) {
                    count.put(n2, new Integer(n4));
                    LinkedList linkedList = remove;
                    synchronized (linkedList) {
                        remove.addFirst(n2);
                    }
                } else {
                    count.remove(n2);
                }
            }
        }
    }

    static {
        try {
            String string = Conf.GetInstance().find("ThreadPool", "config");
            if (string != null) {
                Matcher matcher = Pattern.compile("\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)").matcher(string);
                while (matcher.find()) {
                    int n = Integer.parseInt(matcher.group(1));
                    for (int i = Integer.parseInt(matcher.group(2)); i > 0; --i) {
                        ThreadPool.AddThread(n);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

