/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO;

import com.goldhuman.Common.Conf;
import com.goldhuman.IO.NetIO.NetSession;
import com.goldhuman.IO.NetIO.StreamIO;
import com.goldhuman.IO.PollIO;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public class ActiveIO
extends PollIO {
    boolean closing;
    NetSession assoc_session;

    protected int UpdateEvent() {
        return this.closing ? -1 : 8;
    }

    protected void PollConnect() {
        this.closing = true;
    }

    private ActiveIO(SocketChannel socketChannel, NetSession netSession) {
        super(socketChannel);
        this.assoc_session = netSession;
        this.assoc_session.LoadConfig();
        this.closing = false;
        PollIO.WakeUp();
    }

    public boolean Close() {
        boolean bl = true;
        try {
            SocketChannel socketChannel = (SocketChannel)this.channel;
            if (socketChannel.finishConnect()) {
                bl = false;
                ActiveIO.register(new StreamIO(socketChannel, (NetSession)this.assoc_session.clone()));
                PollIO.WakeUp();
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("assoc_session = " + this.assoc_session + " activeio = " + this);
        }
        try {
            this.assoc_session.OnAbort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("assoc_session = " + this.assoc_session + " activeio = " + this);
            return bl;
        }
        return true;
    }

    public static ActiveIO Open(NetSession netSession) {
        String string;
        Conf conf = Conf.GetInstance();
        String string2 = conf.find(string = netSession.Identification(), "type");
        if (string2.compareToIgnoreCase("tcp") == 0) {
            try {
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(false);
                InetSocketAddress inetSocketAddress = null;
                try {
                    inetSocketAddress = new InetSocketAddress(InetAddress.getByName(conf.find(string, "address")), Integer.parseInt(conf.find(string, "port")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Socket socket = socketChannel.socket();
                try {
                    socket.setReceiveBufferSize(Integer.parseInt(conf.find(string, "so_rcvbuf")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    socket.setSendBufferSize(Integer.parseInt(conf.find(string, "so_sndbuf")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (Integer.parseInt(conf.find(string, "tcp_nodelay")) != 0) {
                        socket.setTcpNoDelay(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                socketChannel.connect(netSession.OnCheckAddress(inetSocketAddress));
                return (ActiveIO)ActiveIO.register(new ActiveIO(socketChannel, (NetSession)netSession.clone()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }
}

