/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO.Protocol;

import com.goldhuman.Common.Marshal.Marshal;
import com.goldhuman.Common.Marshal.MarshalException;
import com.goldhuman.Common.Marshal.OctetsStream;
import com.goldhuman.Common.TimerObserver;
import com.goldhuman.IO.Protocol.Manager;
import com.goldhuman.IO.Protocol.Protocol;
import com.goldhuman.IO.Protocol.ProtocolException;
import com.goldhuman.IO.Protocol.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class Rpc
extends Protocol {
    private static Map map = Collections.synchronizedMap(new HashMap());
    private static HouseKeeper housekeeper = new HouseKeeper();
    private XID xid = new XID();
    private TimerObserver.WatchDog timer = new TimerObserver.WatchDog();
    protected Data argument;
    protected Data result;
    protected long time_policy;

    public OctetsStream marshal(OctetsStream octetsStream) {
        octetsStream.marshal(this.xid);
        octetsStream.marshal(this.xid.IsRequest() ? this.argument : this.result);
        return octetsStream;
    }

    public OctetsStream unmarshal(OctetsStream octetsStream) throws MarshalException {
        octetsStream.unmarshal(this.xid);
        if (this.xid.IsRequest()) {
            return octetsStream.unmarshal(this.argument);
        }
        Rpc rpc = (Rpc)map.get(this.xid);
        if (rpc != null) {
            octetsStream.unmarshal(rpc.result);
        }
        return octetsStream;
    }

    public Object clone() {
        try {
            Rpc rpc = (Rpc)super.clone();
            rpc.xid = (XID)this.xid.clone();
            rpc.timer = new TimerObserver.WatchDog();
            rpc.argument = (Data)this.argument.clone();
            rpc.result = (Data)this.result.clone();
            return rpc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void Process(Manager manager, Session session) throws ProtocolException {
        if (this.xid.IsRequest()) {
            this.Server(this.argument, this.result, manager, session);
            this.xid.ClrRequest();
            manager.Send(session, this);
            return;
        }
        Rpc rpc = (Rpc)map.remove(this.xid);
        if (rpc != null) {
            rpc.Client(rpc.argument, rpc.result);
        }
    }

    protected void Server(Data data, Data data2) throws ProtocolException {
    }

    protected void Server(Data data, Data data2, Manager manager, Session session) throws ProtocolException {
        this.Server(data, data2);
    }

    protected void Client(Data data, Data data2) throws ProtocolException {
    }

    protected void OnTimeout() {
    }

    private static Rpc Call(Rpc rpc, Data data) {
        rpc.xid.SetRequest();
        rpc.argument = data;
        map.put(rpc.xid, rpc);
        return rpc;
    }

    public static Rpc Call(int n, Data data) {
        return Rpc.Call((Rpc)Protocol.Create(n), data);
    }

    public static Rpc Call(String string, Data data) {
        return Rpc.Call((Rpc)Protocol.Create(string), data);
    }

    public static abstract class Data
    implements Marshal,
    Cloneable {
        protected Object clone() {
            try {
                Data data = (Data)super.clone();
                return data;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static class DataVector
        extends Vector
        implements Marshal,
        Cloneable {
            protected Data stub;

            private DataVector() {
            }

            public Object clone() {
                try {
                    DataVector dataVector = (DataVector)super.clone();
                    dataVector.stub = (Data)this.stub.clone();
                    return dataVector;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public DataVector(Data data) {
                this.stub = data;
            }

            public OctetsStream marshal(OctetsStream octetsStream) {
                octetsStream.compact_uint32(this.size());
                for (int i = 0; i < this.size(); ++i) {
                    ((Marshal)this.get(i)).marshal(octetsStream);
                }
                return octetsStream;
            }

            public OctetsStream unmarshal(OctetsStream octetsStream) throws MarshalException {
                int n = octetsStream.uncompact_uint32();
                for (int i = 0; i < n; ++i) {
                    Data data = (Data)this.stub.clone();
                    data.unmarshal(octetsStream);
                    this.add(data);
                }
                return octetsStream;
            }
        }
    }

    private static class XID
    implements Marshal,
    Cloneable {
        public int count = 0;
        private boolean is_request = true;
        private static int xid_count = 0;
        private static Object xid_locker = new Object();

        private XID() {
        }

        public OctetsStream marshal(OctetsStream octetsStream) {
            return octetsStream.marshal(this.is_request ? this.count | Integer.MIN_VALUE : this.count & Integer.MAX_VALUE);
        }

        public OctetsStream unmarshal(OctetsStream octetsStream) throws MarshalException {
            this.count = octetsStream.unmarshal_int();
            this.is_request = (this.count & Integer.MIN_VALUE) != 0;
            return octetsStream;
        }

        public boolean IsRequest() {
            return this.is_request;
        }

        public void ClrRequest() {
            this.is_request = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void SetRequest() {
            this.is_request = true;
            Object object = xid_locker;
            synchronized (object) {
                this.count = xid_count++;
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public boolean equals(Object object) {
            return (((XID)object).count & Integer.MAX_VALUE) == (this.count & Integer.MAX_VALUE);
        }

        public int hashCode() {
            return this.count & Integer.MAX_VALUE;
        }
    }

    private static class HouseKeeper
    implements Observer {
        public HouseKeeper() {
            TimerObserver.GetInstance().addObserver(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable observable, Object object) {
            ArrayList<Rpc> arrayList = new ArrayList<Rpc>();
            Object object2 = map;
            synchronized (object2) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Rpc rpc = (Rpc)iterator.next().getValue();
                    if (rpc.time_policy >= rpc.timer.Elapse()) continue;
                    arrayList.add(rpc);
                    iterator.remove();
                }
            }
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                ((Rpc)object2.next()).OnTimeout();
            }
        }
    }
}

