/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO.Protocol;

import com.goldhuman.Common.Runnable;
import com.goldhuman.Common.ThreadPool;
import com.goldhuman.IO.PollIO;
import com.goldhuman.IO.Protocol.Manager;
import com.goldhuman.IO.Protocol.Protocol;
import com.goldhuman.IO.Protocol.ProtocolException;
import com.goldhuman.IO.Protocol.Session;

public final class Task
extends Runnable {
    private Manager manager;
    private Session session;
    private Protocol protocol;
    private boolean immediately = false;

    private Task(int n, Manager manager, Session session, Protocol protocol) {
        super(n);
        this.manager = manager;
        this.session = session;
        this.protocol = protocol;
    }

    public void run() {
        try {
            this.protocol.Process(this.manager, this.session);
            if (Session.need_wakeup && !this.immediately) {
                PollIO.WakeUp();
                Session.need_wakeup = false;
            }
        }
        catch (ProtocolException protocolException) {
            this.manager.Close(this.session);
        }
    }

    protected static void Dispatch(Manager manager, Session session, Protocol protocol) {
        int n = manager.PriorPolicy(protocol.type);
        Task task = new Task(n, manager, session, protocol);
        if (n > 0) {
            ThreadPool.AddTask(task);
        } else {
            task.immediately = true;
            task.run();
        }
    }
}

