/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.Common.Marshal;

import com.goldhuman.Common.Marshal.Marshal;
import com.goldhuman.Common.Marshal.MarshalException;
import com.goldhuman.Common.Octets;

public class OctetsStream
extends Octets {
    private static final int MAXSPARE = 16384;
    private int pos = 0;
    private int tranpos = 0;

    public OctetsStream() {
    }

    public OctetsStream(int n) {
        super(n);
    }

    public OctetsStream(Octets octets) {
        super(octets);
    }

    public static OctetsStream wrap(Octets octets) {
        OctetsStream octetsStream = new OctetsStream();
        octetsStream.swap(octets);
        return octetsStream;
    }

    public Object clone() {
        OctetsStream octetsStream = (OctetsStream)super.clone();
        octetsStream.pos = this.pos;
        octetsStream.tranpos = this.pos;
        return octetsStream;
    }

    public boolean eos() {
        return this.pos == this.size();
    }

    public OctetsStream marshal(byte by) {
        this.push_back(by);
        return this;
    }

    public OctetsStream marshal(short s) {
        return this.marshal((byte)(s >> 8)).marshal((byte)s);
    }

    public OctetsStream marshal(char c) {
        return this.marshal((byte)(c >> 8)).marshal((byte)c);
    }

    public OctetsStream marshal(int n) {
        return this.marshal((byte)(n >> 24)).marshal((byte)(n >> 16)).marshal((byte)(n >> 8)).marshal((byte)n);
    }

    public OctetsStream marshal(long l) {
        return this.marshal((byte)(l >> 56)).marshal((byte)(l >> 48)).marshal((byte)(l >> 40)).marshal((byte)(l >> 32)).marshal((byte)(l >> 24)).marshal((byte)(l >> 16)).marshal((byte)(l >> 8)).marshal((byte)l);
    }

    public OctetsStream marshal(float f) {
        return this.marshal(Float.floatToRawIntBits(f));
    }

    public OctetsStream marshal(double d) {
        return this.marshal(Double.doubleToRawLongBits(d));
    }

    public OctetsStream compact_uint32(int n) {
        if (n < 64) {
            return this.marshal((byte)n);
        }
        if (n < 16384) {
            return this.marshal((short)(n | 0x8000));
        }
        if (n < 0x20000000) {
            return this.marshal(n | 0xC0000000);
        }
        this.marshal((byte)-32);
        return this.marshal(n);
    }

    public OctetsStream compact_sint32(int n) {
        if (n >= 0) {
            if (n < 64) {
                return this.marshal((byte)n);
            }
            if (n < 8192) {
                return this.marshal((short)(n | 0x8000));
            }
            if (n < 0x10000000) {
                return this.marshal(n | 0xC0000000);
            }
            this.marshal((byte)-32);
            return this.marshal(n);
        }
        if (-n > 0) {
            if ((n = -n) < 64) {
                return this.marshal((byte)(n | 0x40));
            }
            if (n < 8192) {
                return this.marshal((short)(n | 0xA000));
            }
            if (n < 0x10000000) {
                return this.marshal(n | 0xD0000000);
            }
            this.marshal((byte)-16);
            return this.marshal(n);
        }
        this.marshal((byte)-16);
        return this.marshal(n);
    }

    public OctetsStream marshal(Marshal marshal) {
        return marshal.marshal(this);
    }

    public OctetsStream marshal(Octets octets) {
        this.compact_uint32(octets.size());
        this.insert(this.size(), octets);
        return this;
    }

    public OctetsStream Begin() {
        this.tranpos = this.pos;
        return this;
    }

    public OctetsStream Rollback() {
        this.pos = this.tranpos;
        return this;
    }

    public OctetsStream Commit() {
        if (this.pos >= 16384) {
            this.erase(0, this.pos);
            this.pos = 0;
        }
        return this;
    }

    public byte unmarshal_byte() throws MarshalException {
        if (this.pos + 1 > this.size()) {
            throw new MarshalException();
        }
        return this.getByte(this.pos++);
    }

    public short unmarshal_short() throws MarshalException {
        if (this.pos + 2 > this.size()) {
            throw new MarshalException();
        }
        byte by = this.getByte(this.pos++);
        byte by2 = this.getByte(this.pos++);
        return (short)(by << 8 | by2 & 0xFF);
    }

    public char unmarshal_char() throws MarshalException {
        if (this.pos + 2 > this.size()) {
            throw new MarshalException();
        }
        byte by = this.getByte(this.pos++);
        byte by2 = this.getByte(this.pos++);
        return (char)(by << 8 | by2 & 0xFF);
    }

    public int unmarshal_int() throws MarshalException {
        if (this.pos + 4 > this.size()) {
            throw new MarshalException();
        }
        byte by = this.getByte(this.pos++);
        byte by2 = this.getByte(this.pos++);
        byte by3 = this.getByte(this.pos++);
        byte by4 = this.getByte(this.pos++);
        return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | (by4 & 0xFF) << 0;
    }

    public long unmarshal_long() throws MarshalException {
        if (this.pos + 8 > this.size()) {
            throw new MarshalException();
        }
        byte by = this.getByte(this.pos++);
        byte by2 = this.getByte(this.pos++);
        byte by3 = this.getByte(this.pos++);
        byte by4 = this.getByte(this.pos++);
        byte by5 = this.getByte(this.pos++);
        byte by6 = this.getByte(this.pos++);
        byte by7 = this.getByte(this.pos++);
        byte by8 = this.getByte(this.pos++);
        return ((long)by & 0xFFL) << 56 | ((long)by2 & 0xFFL) << 48 | ((long)by3 & 0xFFL) << 40 | ((long)by4 & 0xFFL) << 32 | ((long)by5 & 0xFFL) << 24 | ((long)by6 & 0xFFL) << 16 | ((long)by7 & 0xFFL) << 8 | ((long)by8 & 0xFFL) << 0;
    }

    public float unmarshal_float() throws MarshalException {
        return Float.intBitsToFloat(this.unmarshal_int());
    }

    public double unmarshal_double() throws MarshalException {
        return Double.longBitsToDouble(this.unmarshal_long());
    }

    public int uncompact_uint32() throws MarshalException {
        if (this.pos == this.size()) {
            throw new MarshalException();
        }
        switch (this.getByte(this.pos) & 0xE0) {
            case 224: {
                this.unmarshal_byte();
                return this.unmarshal_int();
            }
            case 192: {
                return this.unmarshal_int() & 0x3FFFFFFF;
            }
            case 128: 
            case 160: {
                return this.unmarshal_short() & Short.MAX_VALUE;
            }
        }
        return this.unmarshal_byte();
    }

    public int uncompact_sint32() throws MarshalException {
        if (this.pos == this.size()) {
            throw new MarshalException();
        }
        switch (this.getByte(this.pos) & 0xF0) {
            case 240: {
                this.unmarshal_byte();
                return -this.unmarshal_int();
            }
            case 224: {
                this.unmarshal_byte();
                return this.unmarshal_int();
            }
            case 208: {
                return -(this.unmarshal_int() & 0x2FFFFFFF);
            }
            case 192: {
                return this.unmarshal_int() & 0x3FFFFFFF;
            }
            case 160: 
            case 176: {
                return -(this.unmarshal_short() & 0x5FFF);
            }
            case 128: 
            case 144: {
                return this.unmarshal_short() & Short.MAX_VALUE;
            }
            case 64: 
            case 80: 
            case 96: 
            case 112: {
                return -(this.unmarshal_byte() & 0xFFFFFFBF);
            }
        }
        return this.unmarshal_byte();
    }

    public Octets unmarshal_Octets() throws MarshalException {
        int n = this.uncompact_uint32();
        if (this.pos + n > this.size()) {
            throw new MarshalException();
        }
        Octets octets = new Octets(this, this.pos, n);
        this.pos += n;
        return octets;
    }

    public OctetsStream unmarshal(Octets octets) throws MarshalException {
        int n = this.uncompact_uint32();
        if (this.pos + n > this.size()) {
            throw new MarshalException();
        }
        octets.replace(this, this.pos, n);
        this.pos += n;
        return this;
    }

    public OctetsStream unmarshal(Marshal marshal) throws MarshalException {
        return marshal.unmarshal(this);
    }
}

