/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO.Protocol;

import com.goldhuman.Common.Marshal.Marshal;
import com.goldhuman.Common.Marshal.MarshalException;
import com.goldhuman.Common.Marshal.OctetsStream;
import com.goldhuman.Common.TimerObserver;
import com.goldhuman.IO.ActiveIO;
import com.goldhuman.IO.PassiveIO;
import com.goldhuman.IO.Protocol.Manager;
import com.goldhuman.IO.Protocol.Parser;
import com.goldhuman.IO.Protocol.ProtocolException;
import com.goldhuman.IO.Protocol.Session;
import com.goldhuman.IO.Protocol.Stream;
import java.util.HashMap;
import java.util.Map;

public abstract class Protocol
implements Marshal,
Cloneable {
    private static final Map map = new HashMap();
    protected int type;
    protected int size_policy;
    protected int prior_policy;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Protocol GetStub(String string) {
        return (Protocol)map.get(string.toUpperCase());
    }

    public static Protocol GetStub(int n) {
        return Protocol.GetStub(Integer.toString(n));
    }

    public static Protocol Create(String string) {
        Protocol protocol = Protocol.GetStub(string);
        return protocol == null ? null : (Protocol)protocol.clone();
    }

    public static Protocol Create(int n) {
        return Protocol.Create(Integer.toString(n));
    }

    protected void Encode(OctetsStream octetsStream) {
        octetsStream.compact_uint32(this.type).marshal(new OctetsStream().marshal(this));
    }

    protected static Protocol Decode(Stream stream) throws ProtocolException {
        Protocol protocol;
        block6: {
            if (stream.eos()) {
                return null;
            }
            protocol = null;
            try {
                int n;
                if (stream.check_policy) {
                    stream.Begin();
                    n = stream.uncompact_uint32();
                    int n2 = stream.uncompact_uint32();
                    stream.Rollback();
                    if (!stream.session.StatePolicy(n) || !stream.session.manager.InputPolicy(n, n2)) {
                        System.out.println("Protocol Decode Error:type=" + n + ",size=" + n2);
                        throw new ProtocolException();
                    }
                    stream.check_policy = false;
                    stream.checked_size = n2;
                }
                Stream stream2 = new Stream(stream.session, stream.checked_size);
                stream.Begin();
                n = stream.uncompact_uint32();
                stream.unmarshal(stream2);
                stream.Commit();
                protocol = Protocol.Create(n);
                if (protocol != null) {
                    protocol.unmarshal(stream2);
                }
            }
            catch (MarshalException marshalException) {
                stream.Rollback();
                if (protocol == null) break block6;
                throw new ProtocolException();
            }
        }
        return protocol;
    }

    public static PassiveIO Server(Manager manager) {
        return PassiveIO.Open(new Session(manager));
    }

    public static ActiveIO Client(Manager manager) {
        return ActiveIO.Open(new Session(manager));
    }

    protected int PriorPolicy() {
        return this.prior_policy;
    }

    protected boolean SizePolicy(int n) {
        return n <= 0 || n < this.size_policy;
    }

    public abstract void Process(Manager var1, Session var2) throws ProtocolException;

    public static void main(String[] stringArray) {
        TimerObserver.GetInstance().StopTimer();
    }

    static {
        try {
            Parser.ParseProtocol(map);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Parser.ParseRpc(map);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

