/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.Common;

import java.nio.ByteBuffer;

public class Octets
implements Cloneable,
Comparable {
    private static final int DEFAULT_SIZE = 128;
    private static String DEFAULT_CHARSET = "ISO-8859-1";
    private byte[] buffer = null;
    private int count = 0;

    private byte[] roundup(int n) {
        int n2;
        for (n2 = 16; n > n2; n2 <<= 1) {
        }
        return new byte[n2];
    }

    public void reserve(int n) {
        if (this.buffer == null) {
            this.buffer = this.roundup(n);
        } else if (n > this.buffer.length) {
            byte[] byArray = this.roundup(n);
            System.arraycopy(this.buffer, 0, byArray, 0, this.count);
            this.buffer = byArray;
        }
    }

    public Octets replace(byte[] byArray, int n, int n2) {
        this.reserve(n2);
        System.arraycopy(byArray, n, this.buffer, 0, n2);
        this.count = n2;
        return this;
    }

    public Octets replace(Octets octets, int n, int n2) {
        return this.replace(octets.buffer, n, n2);
    }

    public Octets replace(byte[] byArray) {
        return this.replace(byArray, 0, byArray.length);
    }

    public Octets replace(Octets octets) {
        return this.replace(octets.buffer, 0, octets.count);
    }

    public Octets() {
        this.reserve(128);
    }

    public Octets(int n) {
        this.reserve(n);
    }

    public Octets(Octets octets) {
        this.replace(octets);
    }

    public Octets(byte[] byArray) {
        this.replace(byArray);
    }

    public Octets(byte[] byArray, int n, int n2) {
        this.replace(byArray, n, n2);
    }

    public Octets(Octets octets, int n, int n2) {
        this.replace(octets, n, n2);
    }

    public Octets resize(int n) {
        this.reserve(n);
        this.count = n;
        return this;
    }

    public int size() {
        return this.count;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public Octets clear() {
        this.count = 0;
        return this;
    }

    public Octets swap(Octets octets) {
        int n = this.count;
        this.count = octets.count;
        octets.count = n;
        byte[] byArray = octets.buffer;
        octets.buffer = this.buffer;
        this.buffer = byArray;
        return this;
    }

    public Octets push_back(byte by) {
        this.reserve(this.count + 1);
        this.buffer[this.count++] = by;
        return this;
    }

    public Octets erase(int n, int n2) {
        System.arraycopy(this.buffer, n2, this.buffer, n, this.count -= n2 - n);
        return this;
    }

    public Octets insert(int n, byte[] byArray, int n2, int n3) {
        this.reserve(this.count + n3);
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this.count - n);
        System.arraycopy(byArray, n2, this.buffer, n, n3);
        this.count += n3;
        return this;
    }

    public Octets insert(int n, Octets octets, int n2, int n3) {
        return this.insert(n, octets.buffer, n2, n3);
    }

    public Octets insert(int n, byte[] byArray) {
        return this.insert(n, byArray, 0, byArray.length);
    }

    public Octets insert(int n, Octets octets) {
        return this.insert(n, octets.buffer, 0, octets.size());
    }

    public Object clone() {
        return new Octets(this);
    }

    public int compareTo(Octets octets) {
        int n = Math.min(this.count, octets.count);
        byte[] byArray = this.buffer;
        byte[] byArray2 = octets.buffer;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] - byArray2[i];
            if (n2 == 0) continue;
            return n2;
        }
        return this.count - octets.count;
    }

    public int compareTo(Object object) {
        return this.compareTo((Octets)object);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buffer, 0, byArray, 0, this.count);
        return byArray;
    }

    public byte[] array() {
        return this.buffer;
    }

    public byte getByte(int n) {
        return this.buffer[n];
    }

    public void setByte(int n, byte by) {
        this.buffer[n] = by;
    }

    public ByteBuffer getByteBuffer(int n, int n2) {
        return ByteBuffer.wrap(this.buffer, n, n2);
    }

    public ByteBuffer getByteBuffer(int n) {
        return ByteBuffer.wrap(this.buffer, n, this.count - n);
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.buffer, 0, this.count);
    }

    public String getString() throws Exception {
        return new String(this.buffer, 0, this.count, DEFAULT_CHARSET);
    }

    public void setString(String string) throws Exception {
        this.buffer = string.getBytes(DEFAULT_CHARSET);
        this.count = this.buffer.length;
    }

    public static void setDefaultCharset(String string) {
        DEFAULT_CHARSET = string;
    }

    public static void main(String[] stringArray) {
        Octets octets = new Octets("ddd".getBytes());
        octets.replace("abc".getBytes());
        octets.replace("defghijklmn".getBytes());
        try {
            octets.replace("0123456789".getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        octets.insert(octets.size(), "abc".getBytes());
        octets.insert(octets.size(), "def".getBytes());
        System.out.println(new String(octets.getBytes()));
        System.out.println("size = " + octets.size());
        Octets octets2 = new Octets("ABC".getBytes());
        octets.insert(octets.size(), octets2);
        System.out.println(new String(octets.getBytes()));
        Octets octets3 = (Octets)octets.clone();
        System.out.println(new String(octets3.getBytes()));
    }
}

