/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.Common.Security;

import com.goldhuman.Common.Octets;
import com.goldhuman.Common.Security.Security;

public final class ARCFourSecurity
extends Security {
    private byte[] perm = new byte[256];
    private byte index1;
    private byte index2;

    protected ARCFourSecurity() {
    }

    public Object clone() {
        try {
            ARCFourSecurity aRCFourSecurity = (ARCFourSecurity)super.clone();
            aRCFourSecurity.perm = new byte[256];
            System.arraycopy(this.perm, 0, aRCFourSecurity.perm, 0, 256);
            return aRCFourSecurity;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void SetParameter(Octets octets) {
        int n;
        int n2 = octets.size();
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            this.perm[n] = (byte)n;
        }
        for (n = 0; n < 256; ++n) {
            n3 = (byte)(n3 + (this.perm[n] + octets.getByte(n % n2)));
            byte by = this.perm[n];
            this.perm[n] = this.perm[n3 & 0xFF];
            this.perm[n3 & 0xFF] = by;
        }
        this.index2 = 0;
        this.index1 = 0;
    }

    public Octets Update(Octets octets) {
        int n = octets.size();
        for (int i = 0; i < n; ++i) {
            this.index1 = (byte)(this.index1 + 1);
            this.index2 = (byte)(this.index2 + this.perm[this.index1 & 0xFF]);
            byte by = this.perm[this.index1 & 0xFF];
            this.perm[this.index1 & 0xFF] = this.perm[this.index2 & 0xFF];
            this.perm[this.index2 & 0xFF] = by;
            byte by2 = (byte)(this.perm[this.index1 & 0xFF] + this.perm[this.index2 & 0xFF]);
            octets.setByte(i, (byte)(octets.getByte(i) ^ this.perm[by2 & 0xFF]));
        }
        return octets;
    }
}

