/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO;

import com.goldhuman.Common.Runnable;
import com.goldhuman.IO.Task;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class PollIO {
    private static Selector iomap = null;
    private static final Runnable task = new Task();
    private static Object regist_locker = new Object();
    protected SelectableChannel channel;

    protected abstract int UpdateEvent();

    protected abstract boolean Close();

    protected void PollIn() {
    }

    protected void PollOut() {
    }

    protected void PollAccept() {
    }

    protected void PollConnect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PollIO register(PollIO pollIO) {
        Object object = regist_locker;
        synchronized (object) {
            PollIO.WakeUp();
            try {
                pollIO.channel.register(iomap, 0, pollIO);
            }
            catch (ClosedChannelException closedChannelException) {
                closedChannelException.printStackTrace();
            }
            return pollIO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void Poll(long l) {
        try {
            PollIO pollIO;
            ArrayList<SelectionKey> arrayList = new ArrayList<SelectionKey>();
            Iterator<Object> iterator = regist_locker;
            synchronized (iterator) {
                Iterator<SelectionKey> object = iomap.keys().iterator();
                while (object.hasNext()) {
                    arrayList.add(object.next());
                }
            }
            for (SelectionKey selectionKey : arrayList) {
                pollIO = (PollIO)selectionKey.attachment();
                int n = pollIO.UpdateEvent();
                if (n == -1) {
                    if (!pollIO.Close()) continue;
                    try {
                        pollIO.channel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    selectionKey.cancel();
                    continue;
                }
                try {
                    selectionKey.interestOps(n);
                }
                catch (Exception exception) {}
            }
            iomap.selectedKeys().clear();
            if (l < 0L) {
                iomap.select();
            } else if (l == 0L) {
                iomap.selectNow();
            } else {
                iomap.select(l);
            }
            for (SelectionKey selectionKey : iomap.selectedKeys()) {
                pollIO = (PollIO)selectionKey.attachment();
                if (selectionKey.isAcceptable()) {
                    pollIO.PollAccept();
                }
                if (selectionKey.isConnectable()) {
                    pollIO.PollConnect();
                }
                if (selectionKey.isReadable()) {
                    pollIO.PollIn();
                }
                if (!selectionKey.isWritable()) continue;
                pollIO.PollOut();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected PollIO(SelectableChannel selectableChannel) {
        try {
            this.channel = selectableChannel;
            selectableChannel.configureBlocking(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Runnable GetTask() {
        return task;
    }

    public static void WakeUp() {
        iomap.wakeup();
    }

    static {
        try {
            iomap = Selector.open();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

