/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO.Protocol;

import com.goldhuman.IO.Protocol.Protocol;
import com.goldhuman.IO.Protocol.Rpc;
import com.goldhuman.IO.Protocol.State;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    private static SAXParser sap;
    private static final URL config;
    public static final String default_package = "protocol";

    private static PrintStream find_file(String string) {
        String string2 = "protocol/" + string;
        File file = new File(string2 + ".java");
        if (file.exists()) {
            if (!new File(string2 + ".class").exists()) {
                System.err.println("Compile " + string2 + ".java first...");
            }
            return null;
        }
        System.out.println("Generate " + file.getName());
        try {
            return new PrintStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void generate_import(PrintStream printStream) {
        printStream.println("package protocol;\n");
        printStream.println("import com.goldhuman.Common.*;");
        printStream.println("import com.goldhuman.Common.Marshal.*;");
        printStream.println("import com.goldhuman.Common.Security.*;");
        printStream.println("import com.goldhuman.IO.Protocol.*;");
        printStream.println("");
    }

    private static void generate_datamember(PrintStream printStream, Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)vector.get(i);
            if (variable.type.endsWith("Vector")) {
                printStream.println("\tpublic DataVector\t" + variable.name + ";");
                continue;
            }
            printStream.println("\tpublic " + variable.type + "\t" + variable.name + ";");
        }
        printStream.println("");
    }

    private static void generate_marshalable(PrintStream printStream, Vector vector) {
        Variable variable;
        int n;
        printStream.println("\tpublic OctetsStream marshal(OctetsStream os)");
        printStream.println("\t{");
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            variable = (Variable)vector.get(n);
            printStream.println("\t\tos.marshal(" + variable.name + ");");
        }
        printStream.println("\t\treturn os;\n\t}");
        printStream.println("");
        printStream.println("\tpublic OctetsStream unmarshal(OctetsStream os) throws MarshalException");
        printStream.println("\t{");
        for (n = 0; n < n2; ++n) {
            variable = (Variable)vector.get(n);
            String string = variable.type;
            if (string.compareTo("int") == 0 || string.compareTo("short") == 0 || string.compareTo("long") == 0 || string.compareTo("byte") == 0 || string.compareTo("float") == 0 || string.compareTo("double") == 0) {
                printStream.println("\t\t" + variable.name + " = os.unmarshal_" + string + "();");
                continue;
            }
            printStream.println("\t\tos.unmarshal(" + variable.name + ");");
        }
        printStream.println("\t\treturn os;\n\t}");
        printStream.println("");
    }

    private static void generate_defaultconstructor(PrintStream printStream, String string, Vector vector) {
        printStream.println("\tpublic " + string + "()");
        printStream.println("\t{");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)vector.get(i);
            String string2 = variable.type;
            String string3 = variable.name;
            if (string2.compareTo("int") == 0 || string2.compareTo("short") == 0 || string2.compareTo("long") == 0 || string2.compareTo("byte") == 0 || string2.compareTo("float") == 0 || string2.compareTo("double") == 0) continue;
            if (variable.type.endsWith("Vector")) {
                printStream.println("\t\t" + string3 + " = new DataVector(" + "new " + string2.replaceAll("Vector", "") + "());");
                continue;
            }
            printStream.println("\t\t" + string3 + " = new " + string2 + "();");
        }
        printStream.println("\t}");
        printStream.println("");
    }

    private static void generate_cloneable(PrintStream printStream, String string, Vector vector) {
        printStream.println("\tpublic Object clone()");
        printStream.println("\t{");
        printStream.println("\t\ttry");
        printStream.println("\t\t{");
        printStream.println("\t\t\t" + string + " o = (" + string + ")super.clone();");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)vector.get(i);
            String string2 = variable.type;
            String string3 = variable.name;
            if (string2.compareTo("int") == 0 || string2.compareTo("short") == 0 || string2.compareTo("long") == 0 || string2.compareTo("byte") == 0 || string2.compareTo("float") == 0 || string2.compareTo("double") == 0) continue;
            if (variable.type.endsWith("Vector")) {
                printStream.println("\t\t\to." + string3 + " = (DataVector)" + string3 + ".clone();");
                continue;
            }
            printStream.println("\t\t\to." + string3 + " = (" + string2 + ")" + string3 + ".clone();");
        }
        printStream.println("\t\t\treturn o;");
        printStream.println("\t\t}");
        printStream.println("\t\tcatch (Exception e) { }");
        printStream.println("\t\treturn null;\n\t}");
        printStream.println("");
    }

    private static void generate_dataaccess(PrintStream printStream, Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)vector.get(i);
            String string = variable.type;
            String string2 = variable.name;
            printStream.println("");
            printStream.println("\tpublic void Set" + string2 + "(" + string + " " + string2 + ") { this." + string2 + " = " + string2 + "; }");
            printStream.println("");
        }
    }

    private static void protocol_generate(String string, Vector vector) {
        PrintStream printStream = Parser.find_file(string);
        if (printStream == null) {
            return;
        }
        Parser.generate_import(printStream);
        printStream.println("public final class " + string + " extends Protocol");
        printStream.println("{");
        Parser.generate_datamember(printStream, vector);
        Parser.generate_defaultconstructor(printStream, string, vector);
        Parser.generate_marshalable(printStream, vector);
        Parser.generate_cloneable(printStream, string, vector);
        printStream.println("\tpublic void Process(Manager manager, Session session) throws ProtocolException");
        printStream.println("\t{");
        printStream.println("\t}");
        printStream.println("");
        printStream.println("}");
        printStream.close();
    }

    private static void rpcdata_generate(String string, Vector vector) {
        PrintStream printStream = Parser.find_file(string);
        if (printStream == null) {
            return;
        }
        Parser.generate_import(printStream);
        printStream.println("public final class " + string + " extends Rpc.Data");
        printStream.println("{");
        Parser.generate_datamember(printStream, vector);
        Parser.generate_defaultconstructor(printStream, string, vector);
        Parser.generate_marshalable(printStream, vector);
        Parser.generate_cloneable(printStream, string, vector);
        printStream.println("}");
        printStream.close();
    }

    private static void rpc_generate(String string, String string2, String string3) {
        PrintStream printStream = Parser.find_file(string);
        if (printStream == null) {
            return;
        }
        Parser.generate_import(printStream);
        printStream.println("public final class " + string + " extends Rpc");
        printStream.println("{");
        printStream.println("\tpublic void Server(Data argument, Data result) throws ProtocolException");
        printStream.println("\t{");
        printStream.println("\t\t" + string2 + " arg = (" + string2 + ")argument;");
        printStream.println("\t\t" + string3 + " res = (" + string3 + ")result;");
        printStream.println("\t}");
        printStream.println("");
        printStream.println("\tpublic void Client(Data argument, Data result) throws ProtocolException");
        printStream.println("\t{");
        printStream.println("\t\t" + string2 + " arg = (" + string2 + ")argument;");
        printStream.println("\t\t" + string3 + " res = (" + string3 + ")result;");
        printStream.println("\t}");
        printStream.println("");
        printStream.println("\tpublic void OnTimeout()");
        printStream.println("\t{");
        printStream.println("\t}");
        printStream.println("");
        printStream.println("}");
        printStream.close();
    }

    protected static void ParseProtocol(final Map map) throws Exception {
        sap.parse(config.openStream(), new DefaultHandler(){
            private boolean parsing = false;
            private String name;
            private String type;
            private String class_name;
            private String maxsize;
            private String priority;
            private Vector variables;

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                try {
                    if (string3.compareTo(Parser.default_package) == 0) {
                        this.parsing = true;
                        this.variables = new Vector();
                        this.name = attributes.getValue("name");
                        this.type = attributes.getValue("type");
                        this.class_name = attributes.getValue("class");
                        this.maxsize = attributes.getValue("maxsize");
                        this.priority = attributes.getValue("priority");
                        if (this.priority == null) {
                            this.priority = attributes.getValue("prior");
                        }
                    } else if (this.parsing && string3.compareTo("variable") == 0) {
                        String string4 = attributes.getValue("type");
                        this.variables.add(new Variable(attributes.getValue("name"), string4));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void endElement(String string, String string2, String string3) {
                if (this.parsing && string3.compareTo(Parser.default_package) == 0) {
                    this.parsing = false;
                    try {
                        Protocol protocol = (Protocol)Class.forName("protocol." + (this.class_name == null ? this.name : this.class_name)).newInstance();
                        protocol.type = Integer.parseInt(this.type);
                        protocol.size_policy = this.maxsize == null ? 0 : Integer.parseInt(this.maxsize);
                        int n = protocol.prior_policy = this.priority == null ? 0 : Integer.parseInt(this.priority);
                        if (map.put(this.name.toUpperCase(), protocol) != null) {
                            System.err.println("Duplicate protocol name " + this.name);
                        }
                        if (map.put(this.type, protocol) != null) {
                            System.err.println("Duplicate protocol type " + this.type);
                        }
                    }
                    catch (Exception exception) {
                        Parser.protocol_generate(this.name, this.variables);
                    }
                    this.name = null;
                    this.type = null;
                    this.class_name = null;
                    this.maxsize = null;
                    this.priority = null;
                    this.variables = null;
                }
            }
        });
    }

    protected static void ParseState(final Map map) throws Exception {
        final HashMap hashMap = new HashMap();
        sap.parse(config.openStream(), new DefaultHandler(){

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if (string3.compareTo(Parser.default_package) != 0 && string3.compareTo("rpc") != 0) {
                    return;
                }
                try {
                    hashMap.put(attributes.getValue("name").trim(), attributes.getValue("type").trim());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        sap.parse(config.openStream(), new DefaultHandler(){
            private String state_name = null;
            private State state = null;

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if (string3.compareTo("state") == 0) {
                    try {
                        this.state_name = attributes.getValue("name").trim().toUpperCase();
                        try {
                            this.state = new State(1000L * Long.parseLong(attributes.getValue("timeout").trim()));
                        }
                        catch (Exception exception) {
                            this.state = new State(0L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.state_name != null && string3.compareTo("proto") == 0) {
                    this.state.AddProtocolType((String)hashMap.get(attributes.getValue("name")));
                }
            }

            public void endElement(String string, String string2, String string3) {
                if (string3.compareTo("state") == 0) {
                    if (this.state_name != null) {
                        map.put(this.state_name, this.state);
                    }
                    this.state_name = null;
                }
            }
        });
    }

    private static final Map ParseRpcData() throws Exception {
        final HashMap hashMap = new HashMap();
        sap.parse(config.openStream(), new DefaultHandler(){
            private boolean parsing = false;
            private String rpcdataName = null;
            private Vector variables;

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                try {
                    if (string3.compareTo("rpcdata") == 0) {
                        this.parsing = true;
                        this.variables = new Vector();
                        this.rpcdataName = attributes.getValue("name");
                    } else if (this.parsing && string3.compareTo("variable") == 0) {
                        String string4 = attributes.getValue("type");
                        this.variables.add(new Variable(attributes.getValue("name"), string4));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void endElement(String string, String string2, String string3) {
                if (this.parsing && string3.compareTo("rpcdata") == 0) {
                    this.parsing = false;
                    try {
                        hashMap.put(this.rpcdataName, Class.forName("protocol." + this.rpcdataName).newInstance());
                    }
                    catch (Exception exception) {
                        Parser.rpcdata_generate(this.rpcdataName, this.variables);
                    }
                    this.rpcdataName = null;
                    this.variables = null;
                }
            }
        });
        return hashMap;
    }

    protected static void ParseRpc(final Map map) throws Exception {
        final Map map2 = Parser.ParseRpcData();
        sap.parse(config.openStream(), new DefaultHandler(){

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if (string3.compareTo("rpc") == 0) {
                    try {
                        String string4 = attributes.getValue("name");
                        String string5 = attributes.getValue("type");
                        String string6 = attributes.getValue("argument");
                        String string7 = attributes.getValue("result");
                        String string8 = attributes.getValue("maxsize");
                        String string9 = attributes.getValue("timeout");
                        String string10 = attributes.getValue("priority");
                        if (string10 == null) {
                            string10 = attributes.getValue("prior");
                        }
                        Rpc rpc = null;
                        try {
                            rpc = (Rpc)Class.forName("protocol." + string4).newInstance();
                        }
                        catch (Exception exception) {
                            Parser.rpc_generate(string4, string6, string7);
                            return;
                        }
                        rpc.argument = (Rpc.Data)map2.get(string6);
                        rpc.result = (Rpc.Data)map2.get(string7);
                        rpc.type = Integer.parseInt(string5);
                        rpc.prior_policy = string10 == null ? 0 : Integer.parseInt(string10);
                        rpc.time_policy = string9 == null ? 25000L : 1000L * Long.parseLong(string9);
                        int n = rpc.size_policy = string8 == null ? 0 : Integer.parseInt(string8);
                        if (map.put(string4.toUpperCase(), rpc) != null) {
                            System.err.println("Duplicate protocol name " + string4);
                        }
                        if (map.put(string5, rpc) != null) {
                            System.err.println("Duplicate protocol type " + string5);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    static {
        config = Parser.class.getResource("/config.xml");
        try {
            sap = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class Variable {
        public String name;
        public String type;

        public Variable(String string, String string2) {
            this.name = string;
            this.type = string2;
        }
    }
}

