/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO.Protocol;

import com.goldhuman.Common.Marshal.OctetsStream;
import com.goldhuman.Common.Octets;
import com.goldhuman.Common.TimerObserver;
import com.goldhuman.IO.NetIO.NetSession;
import com.goldhuman.IO.Protocol.Manager;
import com.goldhuman.IO.Protocol.Protocol;
import com.goldhuman.IO.Protocol.ProtocolException;
import com.goldhuman.IO.Protocol.State;
import com.goldhuman.IO.Protocol.Stream;
import com.goldhuman.IO.Protocol.Task;
import java.net.SocketAddress;
import java.util.LinkedList;

public final class Session
extends NetSession {
    protected Manager manager;
    protected static boolean need_wakeup = false;
    private State state;
    private Stream is;
    private LinkedList os;
    private TimerObserver.WatchDog timer;

    public Object clone() {
        try {
            Session session = (Session)super.clone();
            session.state = new State(this.state);
            session.is = new Stream(this);
            session.os = new LinkedList();
            session.timer = new TimerObserver.WatchDog();
            return session;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String Identification() {
        return this.manager.Identification();
    }

    public SocketAddress OnCheckAddress(SocketAddress socketAddress) {
        return this.manager.OnCheckAddress(socketAddress);
    }

    protected void OnOpen() {
        this.timer.Reset();
        this.manager.AddSession(this);
    }

    protected void OnClose() {
        this.manager.DelSession(this);
    }

    public void OnAbort() {
        this.manager.AbortSession(this);
    }

    protected void OnRecv() {
        this.timer.Reset();
        Octets octets = this.Input();
        this.is.insert(this.is.size(), octets);
        octets.clear();
        try {
            Protocol protocol;
            while ((protocol = Protocol.Decode(this.is)) != null) {
                Task.Dispatch(this.manager, this, protocol);
            }
        }
        catch (ProtocolException protocolException) {
            this.Close();
        }
    }

    protected void OnSend() {
        if (this.state.TimePolicy(this.timer.Elapse())) {
            if (this.os.size() != 0) {
                OctetsStream octetsStream;
                while (this.Output(octetsStream = (OctetsStream)this.os.getFirst())) {
                    this.os.removeFirst();
                    if (this.os.size() != 0) continue;
                }
                this.timer.Reset();
            }
        } else {
            this.Close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean Send(Protocol protocol) {
        Session session = this;
        synchronized (session) {
            OctetsStream octetsStream = new OctetsStream();
            protocol.Encode(octetsStream);
            if (protocol.SizePolicy(octetsStream.size())) {
                this.os.addLast(octetsStream);
                need_wakeup = true;
                return true;
            }
        }
        return false;
    }

    protected boolean StatePolicy(int n) {
        return this.state.TypePolicy(n);
    }

    protected void Close() {
        this.closing = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ChangeState(String string) {
        Session session = this;
        synchronized (session) {
            this.state = State.Get(string);
        }
    }

    public Session(Manager manager) {
        this.manager = manager;
        this.state = this.manager.GetInitState();
    }
}

