/*
 * Decompiled with CFR 0.152.
 */
package application.connection;

import com.goldhuman.xml.xmlobject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.xml.sax.Attributes;

public class handler
extends xmlobject {
    private static Map pools;
    private String url;
    private String username;
    private String password;
    private int initSize;

    public int getInitSize() {
        return this.initSize;
    }

    public static Connection get(String string) {
        if (string == null) {
            return ((SimplePool)pools.entrySet().iterator().next().getValue()).getConnection();
        }
        return ((SimplePool)pools.get(string)).getConnection();
    }

    public static Connection get() {
        return handler.get(null);
    }

    public static void put(Connection connection) {
        try {
            Iterator iterator = pools.entrySet().iterator();
            while (iterator.hasNext()) {
                ((SimplePool)iterator.next().getValue()).returnConnection(connection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setattr(Attributes attributes) {
        super.setattr(attributes);
        this.url = attributes.getValue("url");
        this.username = attributes.getValue("username");
        this.password = attributes.getValue("password");
        String string = attributes.getValue("poolsize");
        this.initSize = string == null ? 10 : Integer.parseInt(string);
    }

    public void action() {
        try {
            if (application.handler.debug) {
                System.err.print("Connect to " + this.url);
            }
            pools.put(this.name, new SimplePool(this.initSize, null, this.url, this.username, this.password));
            if (application.handler.debug) {
                System.err.println("pool of " + this.name + " init successed");
            }
            if (application.handler.debug) {
                System.err.println();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        new Timer().schedule((TimerTask)new CheckTask(), 600000L, 600000L);
        pools = new HashMap();
    }

    class SimplePool {
        private Dummy[] pool = null;
        private int size;
        String connurl;
        String usrname;
        String pwd;

        SimplePool(int n, String string, String string2, String string3, String string4) {
            this.size = n;
            this.connurl = string2;
            handler.this.username = string3;
            this.pwd = string4;
            try {
                this.pool = new Dummy[this.size];
                if (string != null) {
                    Class.forName(string);
                }
                for (int i = 0; i < this.size; ++i) {
                    try {
                        this.pool[i] = new Dummy();
                        this.pool[i].conn = DriverManager.getConnection(this.connurl, handler.this.username, this.pwd);
                        this.pool[i].isValid = true;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public synchronized void doCheck() {
            for (int i = 0; i < this.size; ++i) {
                try {
                    this.pool[i].isValid = !this.pool[i].conn.isClosed();
                }
                catch (Exception exception) {
                    this.pool[i].isValid = false;
                }
                if (this.pool[i].isValid) continue;
                try {
                    this.pool[i].conn = DriverManager.getConnection(this.connurl, handler.this.username, this.pwd);
                    this.pool[i].isValid = true;
                    this.notifyAll();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private Connection _getConnection() {
            for (int i = 0; i < this.size; ++i) {
                if (!this.pool[i].isValid || this.pool[i].isActive) continue;
                this.pool[i].isActive = true;
                return this.pool[i].conn;
            }
            return null;
        }

        public synchronized Connection getConnection() {
            Connection connection = null;
            while ((connection = this._getConnection()) == null) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            return connection;
        }

        public synchronized void returnConnection(Connection connection) {
            for (int i = 0; i < this.size; ++i) {
                if (this.pool[i].conn != connection) continue;
                this.pool[i].isActive = false;
                try {
                    this.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }

        private class Dummy {
            Connection conn;
            boolean isActive = false;
            boolean isValid = false;

            private Dummy() {
            }
        }
    }

    static class CheckTask
    extends TimerTask {
        CheckTask() {
        }

        public void run() {
            Iterator iterator = pools.entrySet().iterator();
            while (iterator.hasNext()) {
                SimplePool simplePool = (SimplePool)iterator.next().getValue();
                simplePool.doCheck();
            }
        }
    }
}

