/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.Common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;

public class Cache {
    public static int default_size = 100;
    public static int default_timeout = 10;
    private Map cache = new HashMap();
    private LRU lru = new LRU();
    private int nitem;
    private int maxsize = default_size;
    private int time_stamp = 0;
    private int life_time = default_timeout;
    private int[] key_pos;
    private static Map all_caches = Collections.synchronizedMap(new HashMap());

    private void add(Item item) {
        item.life_time = this.life_time;
        if (this.cache.size() == this.maxsize) {
            this.remove(this.lru.last());
        }
        this.cache.put(item, item);
        this.lru.add(item);
    }

    private void remove(Item item) {
        item.revoke();
        this.cache.remove(item);
        this.lru.remove(item);
    }

    private boolean contains(Item item) {
        return this.cache.containsKey(item);
    }

    private Cache(int n, int[] nArray) {
        this.nitem = n;
        this.key_pos = nArray;
    }

    private Cache(int n, int[] nArray, int n2, int n3) {
        this.nitem = n;
        this.key_pos = nArray;
        this.maxsize = n2;
        this.life_time = n3;
    }

    public static Cache Create(String string, int n, int[] nArray) {
        Cache cache = new Cache(n, nArray);
        all_caches.put(string, cache);
        return cache;
    }

    public static Cache Create(String string, int n, int[] nArray, int n2, int n3) {
        Cache cache = new Cache(n, nArray, n2, n3);
        all_caches.put(string, cache);
        return cache;
    }

    public static Cache getInstance(String string) {
        return (Cache)all_caches.get(string);
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized Item find(Item item) {
        Item item2 = (Item)this.cache.get(item);
        if (item2 == null) {
            return null;
        }
        this.lru.access(item2);
        return (Item)item2.clone();
    }

    public Item newItem() {
        return new Item(this);
    }

    public static void main(String[] stringArray) {
        Cache cache = Cache.Create("c1", 2, new int[]{0});
        try {
            cache.newItem().set(0, new Integer(1)).set(1, new String("a")).commit();
            cache.newItem().set(0, new Integer(2)).set(1, new String("b")).commit();
            cache.newItem().set(0, new Integer(3)).set(1, new String("c")).commit();
            Item item = cache.find(cache.newItem().set(0, new Integer(1)));
            cache.newItem().set(0, new Integer(4)).set(1, new String("d")).commit();
            Item item2 = cache.find(cache.newItem().set(0, new Integer(3)));
            cache.newItem().set(0, new Integer(5)).set(1, new String("e")).commit();
            System.out.println("Size = " + cache.size());
            Thread.sleep(1000L);
            System.out.println("Size = " + cache.size());
            Thread.sleep(1000L);
            System.out.println("Size = " + cache.size());
            Thread.sleep(1000L);
            System.out.println("Size = " + cache.size());
            Thread.sleep(1000L);
            System.out.println("Size = " + cache.size());
            Thread.sleep(1000L);
            System.out.println("Size = " + cache.size());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        new Timer(true).schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = all_caches;
                synchronized (map) {
                    Iterator iterator = all_caches.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Cache cache;
                        Cache cache2 = cache = (Cache)iterator.next().getValue();
                        synchronized (cache2) {
                            Iterator iterator2 = cache.cache.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Item item = (Item)iterator2.next().getValue();
                                if (--item.life_time > 0) continue;
                                item.revoke();
                                iterator2.remove();
                                cache.lru.remove(item);
                            }
                        }
                    }
                }
            }
        }, 0L, 1000L);
    }

    public class Item
    implements Cloneable {
        private static final int CLEAN = 0;
        private static final int DIRTY = 1;
        private Item origin;
        private int time_stamp;
        private int life_time;
        private int access_count = 0;
        private int status;
        private Object[] items;
        private Cache owner;

        protected Object clone() {
            try {
                Item item = (Item)super.clone();
                item.items = new Object[this.items.length];
                System.arraycopy(this.items, 0, item.items, 0, this.items.length);
                item.origin = this;
                return item;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Item(Cache cache2) {
            this.owner = cache2;
            this.items = new Object[cache2.nitem];
            this.status = 1;
            this.time_stamp = cache2.time_stamp++;
        }

        private void revoke() {
        }

        public boolean equals(Object object) {
            for (int i = 0; i < this.owner.key_pos.length; ++i) {
                if (this.items[Cache.this.key_pos[i]].equals(((Item)object).items[Cache.this.key_pos[i]])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.owner.key_pos.length; ++i) {
                n = n + this.items[Cache.this.key_pos[i]].hashCode() * 17 >> 4;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() throws RuntimeException {
            if (this.status == 0) {
                return;
            }
            Cache cache = this.owner;
            synchronized (cache) {
                if (this.origin == null) {
                    if (this.owner.contains(this)) {
                        throw new RuntimeException("Duplicate Key");
                    }
                } else {
                    if (this.origin.time_stamp != this.time_stamp) {
                        throw new RuntimeException("TimeStamp Collision");
                    }
                    if (this.hashCode() != this.origin.hashCode() || !this.equals(this.origin)) {
                        this.owner.remove(this.origin);
                    }
                    this.time_stamp = this.origin.time_stamp = this.owner.time_stamp++;
                    this.origin = null;
                }
                this.status = 0;
                this.owner.add(this);
            }
        }

        public Item set(int n, Object object) {
            this.items[n] = object;
            this.status = 1;
            return this;
        }

        public Object get(int n) {
            return this.items[n];
        }
    }

    private class LRU {
        private TreeMap lru = new TreeMap();

        private LRU() {
        }

        public void add(Item item) {
            Integer n = new Integer(item.access_count);
            LinkedList<Item> linkedList = (LinkedList<Item>)this.lru.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<Item>();
                this.lru.put(n, linkedList);
            }
            linkedList.addLast(item);
        }

        public void remove(Item item) {
            Integer n = new Integer(item.access_count);
            LinkedList linkedList = (LinkedList)this.lru.get(n);
            linkedList.remove(item);
            if (linkedList.size() == 0) {
                this.lru.remove(n);
            }
        }

        public Item last() {
            return (Item)((LinkedList)this.lru.get(this.lru.firstKey())).getFirst();
        }

        public void access(Item item) {
            this.remove(item);
            item.access_count++;
            this.add(item);
        }
    }
}

