/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO.NetIO;

import com.goldhuman.Common.Conf;
import com.goldhuman.Common.Octets;
import com.goldhuman.Common.Security.Security;
import java.net.SocketAddress;

public abstract class NetSession
implements Cloneable {
    private static final int DEFAULTIOBUF = 8192;
    protected Octets ibuffer = new Octets(8192);
    protected Octets obuffer = new Octets(8192);
    protected Octets isecbuf = new Octets(8192);
    Security isec = Security.Create("NULLSECURITY");
    Security osec = Security.Create("NULLSECURITY");
    protected boolean closing = false;

    protected boolean Output(Octets octets) {
        if (octets.size() + this.obuffer.size() > this.obuffer.capacity()) {
            return false;
        }
        this.osec.Update(octets);
        this.obuffer.insert(this.obuffer.size(), octets);
        return true;
    }

    protected Octets Input() {
        this.isec.Update(this.ibuffer);
        this.isecbuf.insert(this.isecbuf.size(), this.ibuffer);
        this.ibuffer.clear();
        return this.isecbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetISecurity(String string, Octets octets) {
        NetSession netSession = this;
        synchronized (netSession) {
            this.isec = Security.Create(string);
            this.isec.SetParameter(octets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetOSecurity(String string, Octets octets) {
        NetSession netSession = this;
        synchronized (netSession) {
            this.osec = Security.Create(string);
            this.osec.SetParameter(octets);
        }
    }

    public void LoadConfig() {
        Conf conf = Conf.GetInstance();
        String string = this.Identification();
        try {
            this.ibuffer.reserve(Integer.parseInt(conf.find(string, "ibuffermax")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.obuffer.reserve(Integer.parseInt(conf.find(string, "obuffermax")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.SetISecurity(conf.find(string, "isec").trim(), new Octets(conf.find(string, "iseckey").getBytes()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.SetOSecurity(conf.find(string, "osec").trim(), new Octets(conf.find(string, "oseckey").getBytes()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void Close() {
        this.closing = true;
    }

    protected abstract void OnRecv();

    protected abstract void OnSend();

    protected abstract void OnOpen();

    protected abstract void OnClose();

    public void OnAbort() {
    }

    public abstract String Identification();

    public SocketAddress OnCheckAddress(SocketAddress socketAddress) {
        return socketAddress;
    }

    public Object clone() {
        try {
            NetSession netSession = (NetSession)super.clone();
            netSession.ibuffer = new Octets(this.ibuffer.capacity());
            netSession.obuffer = new Octets(this.obuffer.capacity());
            netSession.isecbuf = new Octets(this.isecbuf.capacity());
            netSession.isec = (Security)this.isec.clone();
            netSession.osec = (Security)this.osec.clone();
            return netSession;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

