/*
 * Decompiled with CFR 0.152.
 */
package com.goldhuman.IO.Protocol;

import com.goldhuman.Common.Octets;
import com.goldhuman.IO.Protocol.Protocol;
import com.goldhuman.IO.Protocol.Session;
import com.goldhuman.IO.Protocol.State;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class Manager {
    private Set set = Collections.synchronizedSet(new HashSet());

    protected void AddSession(Session session) {
        this.set.add(session);
        this.OnAddSession(session);
    }

    protected void DelSession(Session session) {
        this.OnDelSession(session);
        this.set.remove(session);
    }

    protected void AbortSession(Session session) {
        this.OnAbortSession(session);
    }

    public boolean SetISecurity(Session session, String string, Octets octets) {
        if (!this.set.contains(session)) {
            return false;
        }
        session.SetISecurity(string, octets);
        return true;
    }

    public boolean SetOSecurity(Session session, String string, Octets octets) {
        if (!this.set.contains(session)) {
            return false;
        }
        session.SetOSecurity(string, octets);
        return true;
    }

    public boolean Send(Session session, Protocol protocol) {
        if (!this.set.contains(session)) {
            return false;
        }
        return session.Send(protocol);
    }

    public boolean Close(Session session) {
        if (!this.set.contains(session)) {
            return false;
        }
        session.Close();
        return true;
    }

    public boolean ChangeState(Session session, String string) {
        if (!this.set.contains(session)) {
            return false;
        }
        session.ChangeState(string);
        return true;
    }

    protected abstract void OnAddSession(Session var1);

    protected abstract void OnDelSession(Session var1);

    protected void OnAbortSession(Session session) {
    }

    protected abstract State GetInitState();

    protected int PriorPolicy(int n) {
        return Protocol.GetStub(n).PriorPolicy();
    }

    protected boolean InputPolicy(int n, int n2) {
        return Protocol.GetStub(n).SizePolicy(n2);
    }

    protected abstract String Identification();

    protected SocketAddress OnCheckAddress(SocketAddress socketAddress) {
        return socketAddress;
    }

    protected Manager() {
    }
}

